// MSVC Viewer.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include "MSVC Viewer.h"

#include "MainFrm.h"
#include "ChildFrm.h"
#include "MSVC ViewerDoc.h"
#include "MSVC ViewerView.h"
#include "QRDialog.h"
#include "inputdialog.h"
#include <afxole.h> // for clipboard check
#include <afxctl.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMSVCViewerApp

BEGIN_MESSAGE_MAP(CMSVCViewerApp, CWinApp)
	//{{AFX_MSG_MAP(CMSVCViewerApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
	ON_COMMAND(ID_FILE_NEW, OnFileNew)
	ON_COMMAND(ID_EDIT_PASTE, OnEditPaste)
	ON_UPDATE_COMMAND_UI(ID_EDIT_PASTE, OnUpdateEditPaste)
	ON_COMMAND(ID_FILE_IMPORT, OnFileImport)
	ON_COMMAND(ID_REMOTE_VERIFY, OnRemoteVerify)
	ON_COMMAND(ID_REMOTE_QUERYOPTIONS, OnRemoteQueryoptions)
	ON_COMMAND(ID_REMOTE_QUERYRETRIEVE, OnRemoteQueryretrieve)
	ON_COMMAND(ID_LOGGING_ENABLELOGGING, OnLoggingEnablelogging)
	ON_COMMAND(ID_LOGGING_LOGDIRECTORY, OnLoggingLogdirectory)
	ON_UPDATE_COMMAND_UI(ID_LOGGING_ENABLELOGGING, OnUpdateLoggingEnablelogging)
	ON_COMMAND(ID_FILE_OPEN, OnFileOpen)
	ON_COMMAND(ID_LOGGING_LOGGINGLEVEL, OnLoggingLogginglevel)
	//}}AFX_MSG_MAP
	// Standard file based document commands
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMSVCViewerApp construction

CMSVCViewerApp::CMSVCViewerApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CMSVCViewerApp object

CMSVCViewerApp theApp;

// This identifier was generated to be statistically unique for your app.
// You may change it if you prefer to choose a specific identifier.

// {856F07E5-B6C5-11D2-A474-0040C711066C}
static const CLSID clsid =
{ 0x856f07e5, 0xb6c5, 0x11d2, { 0xa4, 0x74, 0x0, 0x40, 0xc7, 0x11, 0x6, 0x6c } };

/////////////////////////////////////////////////////////////////////////////
// CMSVCViewerApp initialization

BOOL CMSVCViewerApp::InitInstance()
{
	
	// Initialize OLE libraries
	if (!AfxOleInit())
	{
		AfxMessageBox(IDP_OLE_INIT_FAILED);
		return FALSE;
	}

	AfxEnableControlContainer();

	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

#ifdef _AFXDLL
	Enable3dControls();			// Call this when using MFC in a shared DLL
#else
	Enable3dControlsStatic();	// Call this when linking to MFC statically
#endif

	// Change the registry key under which our settings are stored.
	// You should modify this string to be something appropriate
	// such as the name of your company or organization.
	SetRegistryKey(_T("Local AppWizard-Generated Applications"));

	LoadStdProfileSettings();  // Load standard INI file options (including MRU)

	// Register the application's document templates.  Document templates
	//  serve as the connection between documents, frame windows and views.

	CMultiDocTemplate* pDocTemplate;
	pDocTemplate = new CMultiDocTemplate(
		IDR_DICOMTYPE,
		RUNTIME_CLASS(CMSVCViewerDoc),
		RUNTIME_CLASS(CChildFrame), // custom MDI child frame
		RUNTIME_CLASS(CMSVCViewerView));
	AddDocTemplate(pDocTemplate);

	// Connect the COleTemplateServer to the document template.
	//  The COleTemplateServer creates new documents on behalf
	//  of requesting OLE containers by using information
	//  specified in the document template.
	m_server.ConnectTemplate(clsid, pDocTemplate, FALSE);

	// Register all OLE server factories as running.  This enables the
	//  OLE libraries to create objects from other applications.
	COleTemplateServer::RegisterAll();
		// Note: MDI applications register all server objects without regard
		//  to the /Embedding or /Automation on the command line.

	// create main MDI Frame window
	CMainFrame* pMainFrame = new CMainFrame;
	if (!pMainFrame->LoadFrame(IDR_MAINFRAME))
		return FALSE;
	m_pMainWnd = pMainFrame;

	// Enable drag/drop open
	m_pMainWnd->DragAcceptFiles();

	// Enable DDE Execute open
	EnableShellOpen();
	RegisterShellFileTypes(TRUE);

	// Parse command line for standard shell commands, DDE, file open
	CCommandLineInfo cmdInfo;
	ParseCommandLine(cmdInfo);

	// Check to see if launched as OLE server
	if (cmdInfo.m_bRunEmbedded || cmdInfo.m_bRunAutomated)
	{
		// Application was run with /Embedding or /Automation.  Don't show the
		//  main window in this case.
		return TRUE;
	}

	// When a server application is launched stand-alone, it is a good idea
	//  to update the system registry in case it has been damaged.
	m_server.UpdateRegistry(OAT_DISPATCH_OBJECT);
	COleObjectFactory::UpdateRegistryAll();

	// Dispatch commands specified on the command line
	if (!ProcessShellCommand(cmdInfo))
		return FALSE;

	// The main window has been initialized, so show and update it.
	pMainFrame->ShowWindow(m_nCmdShow);
	pMainFrame->UpdateWindow();

	Server.CreateInstance("DicomObjects8.Dicomserver");
	AfxConnectionAdvise(Server,IID_IDicomServerSink,Sink.GetIDispatch(false),false,&SinkCookie);

	// Create Options dialog
	options.Create(IDD_QROPTIONS);
	qr.Create(IDD_QR_DIALOG);

	global.CreateInstance("DicomObjects8.DicomGlobal");
	
	//Server->Listen(options.m_LocalPort);

	OnAppAbout();

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
		// No message handlers
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// App command to run the dialog
void CMSVCViewerApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}

/////////////////////////////////////////////////////////////////////////////
// CMSVCViewerApp commands


void CMSVCViewerApp::OnFileNew() 
{
	// Over-ridden to do NOTHING - no point in having a NULL image!
	return;
	
}

void CMSVCViewerApp::OnEditPaste() 
{

	IDicomImagePtr image("DicomObjects8.DicomImage");
	image->Paste();

	CMSVCViewerDoc * doc=AddNewImage(image);
	image->Name=doc->GetTitle().AllocSysString();

	doc->UpdateAllViews(NULL);
}

void CMSVCViewerApp::OnUpdateEditPaste(CCmdUI* pCmdUI) 
{
	COleDataObject clip;
	clip.AttachClipboard();
	pCmdUI->Enable(clip.IsDataAvailable(CF_DIB));
}

int CMSVCViewerApp::ExitInstance() 
{
	AfxConnectionUnadvise(Server,IID_IDicomServerSink,Sink.GetIDispatch(false),false,SinkCookie);
	Server.Release();

	// clear some variables here to avoid MFC bug;
	qr.q=NULL;
	global=NULL;
	
	return CWinApp::ExitInstance();
}

CMSVCViewerDoc * CMSVCViewerApp::AddNewImage(IDicomImagePtr image)
{
	// This function provides a common patheay for Paste, 
	// and for images received via the network

	// these next 6 lines are really just m_pDocManager->OnFileNew(),
	// but unformatately, that method wouldn't give a pointer to the new Document !
	POSITION pos;
	CDocTemplate * temp;
	CMSVCViewerDoc * doc;
	pos=m_pDocManager->GetFirstDocTemplatePosition();
	temp= m_pDocManager->GetNextDocTemplate(pos);
	doc	=(CMSVCViewerDoc *)temp->OpenDocumentFile(NULL);

	doc->Image=image;

	return doc;

}


void CMSVCViewerApp::OnFileImport() 
{
	CFileDialog d(true,NULL,NULL,0,_T("Images (*.JPG, *.BMP, *.DIB)|*.JPG;*.BMP;*.DIB||"),NULL);;
	int result=d.DoModal();
	if(result==IDOK)
	{
		IDicomImagePtr image("DicomObjects8.DicomImage");
		image->FileImport(_bstr_t(d.GetPathName()),_bstr_t(""));
		CMSVCViewerDoc * doc=AddNewImage(image);
		doc->UpdateAllViews(NULL);
	}
}
	

void CMSVCViewerApp::OnRemoteVerify() 
{
	int status=global->Echo(_bstr_t(options.m_RemoteIP),options.m_RemotePort,
							_bstr_t(options.m_LocalAET),
							_bstr_t(options.m_RemoteAET));
	if(status==0)
		AfxMessageBox("Verify OK");
	else
	{
		CString m;
		m.Format("Verify failed - status = 0x%x",status);
		AfxMessageBox(m);
	}
}

void CMSVCViewerApp::OnRemoteQueryoptions() 
{
	options.ShowWindow(SW_SHOW);	
}

void CMSVCViewerApp::OnRemoteQueryretrieve() 
{
	if(qr.InitialLoad())
		qr.ShowWindow(SW_SHOWNORMAL);
}

void CMSVCViewerApp::OnLoggingEnablelogging() 
{
	global->RegWord["Log"]=(global->RegWord["Log"]>0)?0:1;
}

void CMSVCViewerApp::OnUpdateLoggingEnablelogging(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(global->RegWord["Log"]>0);
}

void CMSVCViewerApp::OnLoggingLogdirectory() 
{
	CInputDialog d;
	d.m_question="Enter directory for log files";
	if(d.DoModal()==IDOK)
	{
		global->RegString["LogLocation"]=(const char *)d.m_answer;
	}

}

void CMSVCViewerApp::OnLoggingLogginglevel() 
{
	CInputDialog d;
	d.m_question="Enter Log Level (0x3F/63 is normal). Please use decimal format";
	if(d.DoModal()==IDOK)
	{
		global->RegWord["LogLevel"]=atoi(d.m_answer);
	}
}
